#----------------------------------------------------------------------
#  Script prova lettura file GCODE (Marlin) con Julia (hcat)
#  Autore: Andrea Pavan
#  Data: 27/09/2022
#----------------------------------------------------------------------
@time function lettura_gcode(filename::String)

#variabili
nozzleDiameter = 0.4;       #diametro nozzle
path = zeros(Float32,3,1);      #matrice Nx3 dei punti di arrivo
feedrate = zeros(Float32,1,1);      #vettore Nx1 dei feedrate di ciascun tratto lineare


#lettura file GCODE
newPosition = zeros(Float32,3);
newFeedrate = 0f0;
gcode = readlines(filename);
for line in gcode
    if line[1:2] == "G0" || line[1:2] == "G1"
        line_params = split(split(line,';')[1], ' ', keepempty=false);
        for line_param in line_params
            if line_param[1] == 'X'
                newPosition[1] = parse(Float32,line_param[2:end]);
            elseif line_param[1] == 'Y'
                newPosition[2] = parse(Float32,line_param[2:end]);
            elseif line_param[1] == 'Z'
                newPosition[3] = parse(Float32,line_param[2:end]);
            elseif line_param[1] == 'F'
                newFeedrate = parse(Float32,line_param[2:end]);
            end
        end
        path = hcat(path,newPosition);
        feedrate = hcat(feedrate,newFeedrate);
    #else
        #println(line);
    end
end
return vcat(path,feedrate);
end


M = lettura_gcode("esempio_gcode.gcode");
